/**
* Script: numberselector.js
* Written by: Radnen
* Updated: 1/5/2011
**/

function NumberSelector(parent, x, y, max, amt)
{
	this.inherit = Control;
	this.inherit(parent, x, y, 64, 52);
	
	this.onChange = function(){};
	this.amt = amt || 1;
	this.max = max;
	this.value = max;
	
	this.update = function() {
		this.updateMouse();

		if (Cursor.onLeftClick()) {
			if (Cursor.isWithin(this.x+24, this.y, 16, 16)) {
				this.value += this.amt;
				this.onChange();
			}
			if (Cursor.isWithin(this.x+24, this.y+36, 16, 16)) {
				this.value -= this.amt;
				this.onChange();
			}
		}
	}
	
	this.draw = function() {
		this.x = this.parent.x + this.xx;
		this.y = this.parent.y + this.yy;
		
		Rectangle(this.x+24, this.y, 16, 16, Colors.black);
		Rectangle(this.x+24, this.y+36, 16, 16, Colors.black);
		OutlinedRectangle(this.x+24, this.y, 16, 52, Colors.gray);
		Rectangle(this.x, this.y+16, 64, 20, Colors.black);
		OutlinedRectangle(this.x, this.y+16, 64, 20, Colors.gray);
		System.textFont.drawText(this.x+32-System.textFont.getStringWidth(this.value)/2, this.y+18, this.value);
		
		if (Cursor.isWithin(this.x+24, this.y, 16, 16)) {
			Resources.images.up_arrow.blitMask(this.x+24, this.y, Colors.green);
		}
		else Resources.images.up_arrow.blit(this.x+24, this.y);
		if (Cursor.isWithin(this.x+24, this.y+36, 16, 16)) {
			Resources.images.dn_arrow.blitMask(this.x+24, this.y+36, Colors.green);
		}
		else Resources.images.dn_arrow.blit(this.x+24, this.y+36);
	}
}